/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.entity.Entity"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode methodNode : classNode.methods) {
            String methodName = this.mapMethodName(classNode, methodNode);
            if (methodNode.name.equals("hasCapability")) {
                this.clearInstructions(methodNode);
                methodNode.instructions.insert(this.fasterCapabilityCheck());
                continue;
            }
            if (methodName.equals("getBrightnessForRender") || methodName.equals("func_70070_b")) {
                this.clearInstructions(methodNode);
                methodNode.instructions.insert(this.getFixedBrightness());
                continue;
            }
            if (!methodName.equals("spawnRunningParticles") && !methodName.equals("func_174830_Y")) continue;
            ListIterator iterator = methodNode.instructions.iterator();
            LabelNode ifeq = new LabelNode();
            while (iterator.hasNext()) {
                String methodInsnName;
                AbstractInsnNode next = (AbstractInsnNode)iterator.next();
                if (next instanceof JumpInsnNode && next.getOpcode() == 154) {
                    methodNode.instructions.insert(next.getNext(), this.checkOnGround(ifeq));
                    continue;
                }
                if (!(next instanceof MethodInsnNode) || next.getOpcode() != 182 || !(methodInsnName = this.mapMethodNameFromNode(next)).equals("createRunningParticles") && !methodInsnName.equals("func_174808_Z")) continue;
                methodNode.instructions.insert(next.getNext(), (AbstractInsnNode)ifeq);
            }
        }
    }

    private InsnList checkOnGround(LabelNode ifeq) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "field_70122_E", "Z"));
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        return list;
    }

    private InsnList getFixedBrightness() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new TypeInsnNode(187, "net/minecraft/util/BlockPos"));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "field_70165_t", "D"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "field_70163_u", "D"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/Entity", "func_70047_e", "()F", false));
        list.add((AbstractInsnNode)new InsnNode(141));
        list.add((AbstractInsnNode)new InsnNode(99));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "field_70161_v", "D"));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/util/BlockPos", "<init>", "(DDD)V", false));
        list.add((AbstractInsnNode)new VarInsnNode(58, 2));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "field_70170_p", "Lnet/minecraft/world/World;"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new InsnNode(3));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", "func_175626_b", "(Lnet/minecraft/util/BlockPos;I)I", false));
        list.add((AbstractInsnNode)new InsnNode(172));
        return list;
    }

    private InsnList fasterCapabilityCheck() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "capabilities", "Lnet/minecraftforge/common/capabilities/CapabilityDispatcher;"));
        LabelNode labelNode = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(198, labelNode));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "capabilities", "Lnet/minecraftforge/common/capabilities/CapabilityDispatcher;"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/common/capabilities/CapabilityDispatcher", "hasCapability", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Z", false));
        list.add((AbstractInsnNode)new JumpInsnNode(153, labelNode));
        list.add((AbstractInsnNode)new InsnNode(4));
        LabelNode gotoInsn = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(167, gotoInsn));
        list.add((AbstractInsnNode)labelNode);
        list.add((AbstractInsnNode)new InsnNode(3));
        list.add((AbstractInsnNode)gotoInsn);
        list.add((AbstractInsnNode)new InsnNode(172));
        return list;
    }
}

